ViewSettings = {
    Cockpit = {
        CockpitAnchorPoint = {0.810, 0.795, 0.260},
        [1] = {-- player slot 1
            CameraViewAngleLimits  = {20.0, 140.0},
            CockpitLocalPoint      = {0.829, 0.919, -0.242},
            CameraAngleRestriction = {false, 90.0, 0.5},
            CameraAngleLimits      = {180.0, -90.0, 90.0},
            EyePoint               = {0.050, 0.100, 0.000},
            ShoulderSize           = 0.25,
            Allow360rotation       = false,
            limits_6DOF            = {x = {-10.080, 10.392}, y = {-10.250, 10.080}, z = {-10.188, 10.188}, roll = 90.0},
        },
        [2] = {-- player slot 2
            CameraViewAngleLimits  = {20.0, 140.0},
            CockpitLocalPoint      = {0.556, 0.823, 0.260},
            CameraAngleRestriction = {false, 90.0, 0.5},
            CameraAngleLimits      = {180.0, -90.0, 90.0},
            EyePoint               = {0.050, 0.100, 0.000},
            ShoulderSize           = 0.25,
            Allow360rotation       = true,
            limits_6DOF            = {x = {-10.080, 10.392}, y = {-10.250, 10.080}, z = {-10.188, 10.188}, roll = 90.0},
        },
    }, -- Cockpit 
    Chase = {
        LocalPoint      = {0.000, -0.191, -1.146},
        AnglesDefault   = {0.456, 0.437},
    }, -- Chase 
    Arcade = {
        LocalPoint      = {-21.500, 5.618, 0.000},
        AnglesDefault   = {0.0, -8.0},
    }, -- Arcade 
}

local function head_pos_default(tab)
    if not tab then
        tab = {}
    end

    tab.viewAngle = tab.viewAngle  or  80
    tab.hAngle    = tab.hAngle     or  0
    tab.vAngle    = tab.vAngle     or  0
    tab.x_trans   = tab.x_trans    or  0
    tab.y_trans   = tab.y_trans    or  0
    tab.z_trans   = tab.z_trans    or  0
    tab.rollAngle = tab.rollAngle  or  0
    
    return tab
end


SnapViews = {
    [1] = { -- Player Slot 1
        [1] = head_pos_default({}), -- Num0
        [2] = { -- LWin + Num1 - Snap View 1 - LH Board
            viewAngle = 60.0,
            x_trans   = 0.100,
            y_trans   = 0.000,
            z_trans   = -0.100,
            hAngle    = 53.9,
            vAngle    = -52.5,
            rollAngle = -10.0,
        },
        [3] = { -- LWin + Num2 - Snap View 2 - Front Panel
            viewAngle = 60.0,
            x_trans   = 0.090,
            y_trans   = -0.050,
            z_trans   = 0.000,
            hAngle    = 0.0,
            vAngle    = -29.7,
            rollAngle = 0.0,
        },
        [4] = { -- LWin + Num3 - Snap View 3 - RH Board
            viewAngle = 50.0,
            x_trans   = 0.000,
            y_trans   = -0.091,
            z_trans   = 0.033,
            hAngle    = -55.6,
            vAngle    = -41.2,
            rollAngle = 0.0,
        },
        [5] = { -- LWin + Num4 - Snap View 4 - Left 6
            viewAngle = 80.0,
            x_trans   = 0.000,
            y_trans   = 0.000,
            z_trans   = 0.000,
            hAngle    = 150.0,
            vAngle    = 0.0,
            rollAngle = 0.0,
        },
        [6] = { -- LWin + Num5 - Snap View 5 - Reticle
            viewAngle = 50.0,
            x_trans   = 0.225,
            y_trans   = 0.011,
            z_trans   = 0.000,
            hAngle    = 0.0,
            vAngle    = 1.5,
            rollAngle = 0.0,
        },
        [7] = { -- LWin + Num6 - Snap View 6 - Right 6
            viewAngle = 80.0,
            x_trans   = 0.000,
            y_trans   = 0.000,
            z_trans   = 0.000,
            hAngle    = -150.0,
            vAngle    = 0.0,
            rollAngle = 0.0,
        },
        [8] = { -- LWin + Num7 - Snap View 7 - Left 10
            viewAngle = 80.0,
            x_trans   = 0.000,
            y_trans   = 0.000,
            z_trans   = 0.000,
            hAngle    = 45.0,
            vAngle    = 0.0,
            rollAngle = 0.0,
        },
        [9] = { -- LWin + Num8 - Snap View 8 - Cowl
            viewAngle = 80.0,
            x_trans   = 0.152,
            y_trans   = 0.066,
            z_trans   = -0.100,
            hAngle    = 0.0,
            vAngle    = -7.0,
            rollAngle = 0.0,
        },
        [10] = { -- LWin + Num9 - Snap View 9 - Right 10
            viewAngle = 80.0,
            x_trans   = 0.000,
            y_trans   = 0.000,
            z_trans   = 0.000,
            hAngle    = -45.0,
            vAngle    = 0.0,
            rollAngle = 0.0,
        },
        [11] = head_pos_default({viewAngle = 60, vAngle = 10}), -- Look at left mirror
        [12] = head_pos_default({viewAngle = 60, vAngle = 10}), -- Look at right mirror
        [13] = head_pos_default(), -- Default View
        [14] = head_pos_default({x_trans = 0.080, y_trans = 0.017, z_trans = 0.029,}), -- HMD View
    },
    [2] = { -- Player Slot 2
        [1] = head_pos_default({}), -- Num0
        [2] = { -- LWin + Num1 - Snap View 1 - LH Board
            viewAngle = 60.0,
            x_trans   = 0.100,
            y_trans   = 0.000,
            z_trans   = -0.100,
            hAngle    = 53.9,
            vAngle    = -52.5,
            rollAngle = -10.0,
        },
        [3] = { -- LWin + Num2 - Snap View 2 - Front Panel
            viewAngle = 60.0,
            x_trans   = 0.090,
            y_trans   = -0.050,
            z_trans   = 0.000,
            hAngle    = 0.0,
            vAngle    = -29.7,
            rollAngle = 0.0,
        },
        [4] = { -- LWin + Num3 - Snap View 3 - RH Board
            viewAngle = 50.0,
            x_trans   = 0.000,
            y_trans   = -0.091,
            z_trans   = 0.033,
            hAngle    = -55.6,
            vAngle    = -41.2,
            rollAngle = 0.0,
        },
        [5] = { -- LWin + Num4 - Snap View 4 - Left 6
            viewAngle = 80.0,
            x_trans   = 0.000,
            y_trans   = 0.000,
            z_trans   = 0.000,
            hAngle    = 150.0,
            vAngle    = 0.0,
            rollAngle = 0.0,
        },
        [6] = { -- LWin + Num5 - Snap View 5 - Reticle
            viewAngle = 50.0,
            x_trans   = 0.225,
            y_trans   = 0.011,
            z_trans   = 0.000,
            hAngle    = 0.0,
            vAngle    = 1.5,
            rollAngle = 0.0,
        },
        [7] = { -- LWin + Num6 - Snap View 6 - Right 6
            viewAngle = 80.0,
            x_trans   = 0.000,
            y_trans   = 0.000,
            z_trans   = 0.000,
            hAngle    = -150.0,
            vAngle    = 0.0,
            rollAngle = 0.0,
        },
        [8] = { -- LWin + Num7 - Snap View 7 - Left 10
            viewAngle = 80.0,
            x_trans   = 0.000,
            y_trans   = 0.000,
            z_trans   = 0.000,
            hAngle    = 45.0,
            vAngle    = 0.0,
            rollAngle = 0.0,
        },
        [9] = { -- LWin + Num8 - Snap View 8 - Cowl
            viewAngle = 80.0,
            x_trans   = 0.152,
            y_trans   = 0.066,
            z_trans   = -0.100,
            hAngle    = 0.0,
            vAngle    = -7.0,
            rollAngle = 0.0,
        },
        [10] = { -- LWin + Num9 - Snap View 9 - Right 10
            viewAngle = 80.0,
            x_trans   = 0.000,
            y_trans   = 0.000,
            z_trans   = 0.000,
            hAngle    = -45.0,
            vAngle    = 0.0,
            rollAngle = 0.0,
        },
        [11] = head_pos_default({viewAngle = 60, vAngle = 10}), -- Look at left mirror
        [12] = head_pos_default({viewAngle = 60, vAngle = 10}), -- Look at right mirror
        [13] = head_pos_default(), -- Default View
        [14] = head_pos_default({x_trans = 0.075, y_trans = 0.045, z_trans = -0.026,}), -- HMD View
    },
}
